﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Menu.Sample7
{
    public partial class FormMain : Form
    {
        //horizontally
        private int TPM_CentralAlign = 0x0004;
        private int TPM_LeftAlign = 0x0000;
        private int TPM_RightAlign = 0x0008;

        //vertically
        private int TPM_BotoomAlign = 0x0020;
        private int TPM_TopAlign = 0x0000;
        private int TPM_VCenterAlign = 0x0010;

        //Control Menu
        private int TPM_NoNotify = 0x0080;
        private int TPM_ReturnCmd = 0x0100;

        //MouseClick
        private int TPM_LeftButton = 0x0000;
        private int TPM_RightButton = 0x0002;

        // Animation
        private int TPM_HorNegAnimation = 0x0800;
        private int TPM_HorPosAnimation = 0x0400;
        private int TPM_NoAnimation = 0x4000;
        private int TPM_VerNegAnimation = 0x2000;
        private int TPM_VerPosAnimation = 0x1000;

        [DllImport("user32.dll", SetLastError = true)]
        private static extern IntPtr GetMenuItemID(IntPtr hMenu, int nPosition);

        [DllImport("user32.dll", SetLastError = true)]
        public static extern IntPtr GetSystemMenu(IntPtr hwnd, bool bRevert);

        [DllImport("user32.dll")]
        public static extern int TrackPopupMenuEx(IntPtr hMenu, int uFlags, int x, int y, IntPtr hwnd, IntPtr lptpm);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonShowMenu_Click(object sender, EventArgs e)
        {
            IntPtr hSystemMenu = GetSystemMenu(this.Handle, false);
            if (hSystemMenu == IntPtr.Zero) return;

            IntPtr closeMenuItemId = GetMenuItemID(hSystemMenu, 6);
            IntPtr minimizeMenuItemId = GetMenuItemID(hSystemMenu, 3);
            IntPtr maximizeMenuItemId = GetMenuItemID(hSystemMenu, 4);

            int id = TrackPopupMenuEx(hSystemMenu, TPM_VCenterAlign | TPM_ReturnCmd | TPM_RightButton | TPM_HorPosAnimation, Cursor.Position.X, Cursor.Position.Y, buttonShowMenu.Handle, IntPtr.Zero);
            if (id == closeMenuItemId.ToInt32())
                this.Close();
            else if (id == minimizeMenuItemId.ToInt32())
                this.WindowState = FormWindowState.Maximized;
            else if (id == maximizeMenuItemId.ToInt32())
                this.WindowState = FormWindowState.Minimized;
        }
    }
}